/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.core.Agent;
import jade.core.CaseInsensitiveString;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.UnsupportedValue;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SimpleAchieveREResponder;
import jade.security.JADESecurityException;
import jade.util.Logger;

public abstract class RequestManagementBehaviour
extends SimpleAchieveREResponder {
    private ACLMessage notification;
    private Logger myLogger;

    protected RequestManagementBehaviour(Agent a, MessageTemplate mt) {
        super(a, mt);
        if (this.myAgent != null) {
            this.myLogger = Logger.getMyLogger(this.myAgent.getLocalName());
        }
    }

    public void onStart() {
        if (this.myLogger == null) {
            this.myLogger = Logger.getMyLogger(this.myAgent.getLocalName());
        }
        super.onStart();
    }

    protected abstract ACLMessage performAction(Action var1, ACLMessage var2) throws JADESecurityException, FIPAException;

    protected ACLMessage prepareResponse(ACLMessage request) throws NotUnderstoodException, RefuseException {
        ACLMessage response = null;
        Exception t = null;
        try {
            this.isAnSLRequest(request);
            Action slAction = (Action)this.myAgent.getContentManager().extractContent(request);
            this.notification = this.performAction(slAction, request);
        }
        catch (OntologyException oe) {
            response = request.createReply();
            response.setPerformative(10);
            response.setContent("(unrecognised-value content)");
            t = oe;
        }
        catch (Codec.CodecException ce) {
            response = request.createReply();
            response.setPerformative(10);
            response.setContent("(unrecognised-value content)");
            t = ce;
        }
        catch (RefuseException re) {
            response = request.createReply();
            response.setPerformative(14);
            response.setContent(this.prepareErrorContent(request.getContent(), re.getMessage()));
            t = re;
        }
        catch (FailureException fe) {
            this.notification = request.createReply();
            this.notification.setPerformative(6);
            this.notification.setContent(this.prepareErrorContent(request.getContent(), fe.getMessage()));
            t = fe;
        }
        catch (FIPAException fe) {
            response = request.createReply();
            response.setPerformative(10);
            response.setContent("(" + fe.getMessage() + ")");
            t = fe;
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            this.notification = request.createReply();
            this.notification.setPerformative(6);
            this.notification.setContent(this.prepareErrorContent(request.getContent(), "internal-error \"" + t + "\""));
        }
        if (t != null && this.myLogger.isLoggable(7)) {
            this.myLogger.log(7, "Error handling request: " + t);
            t.printStackTrace();
        }
        return response;
    }

    protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) throws FailureException {
        return this.notification;
    }

    public void reset() {
        super.reset();
        this.notification = null;
    }

    private void isAnSLRequest(ACLMessage msg) throws FIPAException {
        String language = msg.getLanguage();
        if (!(CaseInsensitiveString.equalsIgnoreCase("fipa-sl0", language) || CaseInsensitiveString.equalsIgnoreCase("fipa-sl1", language) || CaseInsensitiveString.equalsIgnoreCase("fipa-sl2", language) || CaseInsensitiveString.equalsIgnoreCase("fipa-sl", language))) {
            throw new UnsupportedValue("language");
        }
    }

    private String prepareErrorContent(String content, String e) {
        String tmp = content.trim();
        tmp = tmp.substring(1, tmp.length() - 1);
        return "(" + tmp + " " + e + ")";
    }
}

